<?php
session_start();
include '../conexion.php';

$idmov = $_POST['idfactura'] ?? null;
$fechaDev = $_POST['fechaDev'] ?? null;
$fecha=null;
$empleado=null;
$lugarTrabajo=null;
$numEmp=null;
$estatus = $_POST['estatus'] ?? null;
$fila=null;

if (empty($idmov)) {
    die("El ID de factura no puede estar vacío.");
}

if($estatus==0){
    $estatus="";
}else {
    $estatus="disabled";
}

$stmt = $connection->prepare("SELECT * FROM datos_e WHERE idmovimientosUni = ?");
$stmt->bind_param("s", $idmov);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $fecha=htmlspecialchars($row['fechaMov']);
            $empleado=htmlspecialchars($row['dato1']);
            $lugarTrabajo=htmlspecialchars($row['dato2']);
            $numEmp=htmlspecialchars($row['num_emp']);

            $empleado=$numEmp." | ".$empleado;
            switch($row['ubicacion']){
                case 'TIJUANA':$sucursal='1';break;
                case 'ENSENADA':$sucursal='2';break;
                case 'MEXICALI':$sucursal='3';break;

            }
        }
    } else {
        echo "No se encontraron registros.";
    }
} else {
    echo "Error en la consulta: " . $stmt->error;
}

$stmt = $connection->prepare("SELECT * FROM datos_entregas WHERE idmovimientosUni = ?");
$stmt->bind_param("s", $idmov);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $fila=null;
        while ($row = $result->fetch_assoc()) {
            $fila .= '<tr>
    
    <td style="width:54%">
        <input disabled style="font-size: 10px;" type="hidden" class="form-control" name="idw[]" value="'.$row['uni_uniforme_iduniforme'].'" size="3">
        <input disabled style="font-size: 10px;" type="text" class="form-control" name="uniformew[]" value="'.$row['descrip'].'">
    </td>
    <td style="width:10%">
        <input disabled style="font-size: 10px;text-align:right;" type="text" class="form-control cantidadw" name="cantidadw[]" value="'.$row['cant'].'">
    </td>
    <td style="width:13%">
        <select style="font-size: 10px;" class="form-control cantdev" '.$estatus.' name="cantdev[]" onchange="updateFields(this)">
            ';
            for($i = 0; $i <= $row['cant']; $i++) {
                $selected = ($i == $row['buen']) ? 'selected' : '';
                $fila .= '<option value="'.$i.'" '.$selected.'>'.$i.'</option>';
            }
            $fila .= '
        </select>
    </td>
    <td style="width:13%">
        <select style="font-size: 10px;" class="form-control basura" '.$estatus.' name="cantbas[]" onchange="updateFields(this)">
            ';
            for($i = 0; $i <= $row['cant']; $i++) {
                $selected = ($i == $row['mal']) ? 'selected' : '';
                $fila .= '<option value="'.$i.'" '.$selected.'>'.$i.'</option>';
            }
            $fila .= '
        </select>
    </td>
    <td style="width:10%">
        <button disabled type="button" class="btn btn-danger" onclick="eliminarFilaTablaw(this)">
            <i class="fa-solid fa-eraser"></i>
        </button>
    </td>
</tr>

<script>
function updateFields(selectElement) {
    // Obtener la fila actual
    const row = selectElement.closest("tr");

    // Obtener los valores de los campos
    const cantidad = parseInt(row.querySelector(".cantidadw").value) || 0;
    const cantdev = parseInt(row.querySelector(".cantdev").value) || 0;
    const basura = parseInt(row.querySelector(".basura").value) || 0;

    // Calcular nuevos valores
    if (selectElement.classList.contains("cantdev")) {
        row.querySelector(".basura").value = cantidad - cantdev;
    } else if (selectElement.classList.contains("basura")) {
        row.querySelector(".cantdev").value = cantidad - basura;
    }
}
</script>
';
        }
    } else {
        echo "No se encontraron registros.";
    }
} else {
    echo "Error en la consulta: " . $stmt->error;
}

$stmt->close();
$connection->close();

$mensaje = array(
    'fecha' => $fecha,
    'empleadox'=>$empleado,
    'sucursal'=>$sucursal,
    'fila'=>$fila
);
    
echo json_encode($mensaje);		
?>