<?php
session_start();
include '../conexion.php';
mysqli_set_charset($connection, "utf8");


$idUsuario = $_POST['idUsuario'] ?? null;

if (empty($idUsuario)) {
    die("El ID de usuario no puede estar vacío.");
}

$stmt = $connection->prepare("SELECT * FROM uni_empleados WHERE idempleado = ?");
$stmt->bind_param("s", $idUsuario);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $nombre=htmlspecialchars($row['nombre']);
            $num=htmlspecialchars($row['num_emp']);
            $ubicacion=htmlspecialchars($row['ubicacion']);
            $supervisor=htmlspecialchars($row['supervisor']);
            $lugar=htmlspecialchars($row['lugar_trabajo']);
            $id=htmlspecialchars($row['idempleado']);
        }
    } else {
        echo "No se encontraron registros.";
    }
} else {
    echo "Error en la consulta: " . $stmt->error;
}

//$valor.="";


$mensaje = array(
    'nombre' => $nombre,
    'num'=>$num,
    'supervisor'=>$supervisor,
    'ubicacion'=>$ubicacion,
    'lugar'=>$lugar,
    'id'=>$id

    
);
    
echo json_encode($mensaje);		
?>