<?php
session_start();
include '../conexion.php';
mysqli_set_charset($connection, "utf8");


$idUsuario = $_POST['idUsuario'] ?? null;

if (empty($idUsuario)) {
    die("El ID de usuario no puede estar vacío.");
}

$stmt = $connection->prepare("SELECT * FROM uni_proveedor WHERE idproveedorUni = ?");
$stmt->bind_param("s", $idUsuario);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $nombre=htmlspecialchars($row['nombre']);
            $rfc=htmlspecialchars($row['rfc']);
            $contacto=htmlspecialchars($row['contacto']);
            $telefono=htmlspecialchars($row['telefono']);
            $correo=htmlspecialchars($row['correo']);
            $id=htmlspecialchars($row['idproveedorUni']);
        }
    } else {
        echo "No se encontraron registros.";
    }
} else {
    echo "Error en la consulta: " . $stmt->error;
}



$mensaje = array(
    'nombre' => $nombre,
    'rfc'=>$rfc,
    'contacto'=>$contacto,
    'telefono'=>$telefono,
    'correo'=>$correo,
    'id'=>$id

    
);
    
echo json_encode($mensaje);		
?>