<?php
include '../conexion.php';
mysqli_set_charset($connection, "utf8");

$response = array();

// Función para enviar la respuesta como JSON
function sendResponse($success, $message, $data = null) {
    http_response_code($success ? 200 : 400);
    echo json_encode([
        'success' => $success,
        'message' => $message,
        'dato' => $data
    ]);
    exit;
}

// Verificar que la solicitud sea POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Método no permitido.');
}

// Recibir los datos enviados
$tipo = isset($_POST['tipo']) ? trim($_POST['tipo']) : null;
$medida = isset($_POST['medida']) ? trim($_POST['medida']) : null;
$estado = isset($_POST['estado']) ? trim($_POST['estado']) : null;
$uniforme = strtoupper(isset($_POST['uniforme']) ? preg_replace('/\s{2,}/', ' ', trim($_POST['uniforme'])) : null);



    if (empty($uniforme) || $medida=='0' || $tipo=='0' || $estado=='0') {
        sendResponse(false, 'Datos incompletos para el registro.');
    }

    $connection->begin_transaction();

    try {
        $stmtx = $connection->prepare("SELECT * FROM uni_uniforme WHERE u_descripcion = ? and uni_medidas_idmedidasuni=? and uni_estado_idestadouni=?");
        $stmtx->bind_param("sss", $uniforme,$medida,$estado);
        $stmtx->execute();
        $result = $stmtx->get_result();

        if ($result->num_rows > 0) {
            sendResponse(true, 'Uniforme ya existe.', false);
        }

        $stmtx = $connection->prepare("SELECT ordena FROM uni_uniforme WHERE u_descripcion=?");
        $stmtx->bind_param("s", $uniforme);
        $stmtx->execute();
        $result = $stmtx->get_result();

        $max=null;

        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $max=$row['ordena'];
            }
        } else{
            $stmtx = $connection->prepare("SELECT max(ordena) as ordena FROM uni_uniforme");
            //$stmtx->bind_param("s", $uniforme);
            $stmtx->execute();
            $result = $stmtx->get_result();
    
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    $max=$row['ordena']+1;
                }
            }   
        }

        $stmt = $connection->prepare("INSERT INTO uni_uniforme(ordena,uni_medidas_idmedidasuni,uni_estado_idestadouni,u_descripcion) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $max, $medida, $estado, $uniforme);
        $stmt->execute();

        $connection->commit();
        sendResponse(true, 'Uniforme registrado con éxito.', true);

    } catch (Exception $e) {
        $connection->rollback();
        sendResponse(false, 'Error al registrar uniforme: ' . $e->getMessage());
    } finally {
        $stmtx->close();
        $stmt->close();
        $connection->close();
    }


?>
