<?php
include '../conexion.php';
mysqli_set_charset($connection, "utf8");

//header('Content-Type: application/json'); // Para asegurarte de que devuelves un JSON
//$response = array();



    // Verificar que la solicitud sea POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método no permitido.');
    }

    // Recibir los datos enviados
    $nombre = isset($_POST['nombre']) ? trim(strtoupper($_POST['nombre'])) : null;
    $rfc= isset($_POST['rfc']) ? trim(strtoupper($_POST['rfc'])) : null;
    $contacto = isset($_POST['contacto']) ? trim(strtoupper($_POST['contacto'])) : null;
    $telefono = isset($_POST['telefono']) ? trim($_POST['telefono']) : null;
    $correo = isset($_POST['correo']) ? trim($_POST['correo']) : null;

            // Iniciar una transacción
        $connection->begin_transaction();

        try {
            
            $stmtx = $connection->prepare("SELECT * FROM uni_proveedor WHERE nombre = ?");
            $stmtx->bind_param("s", $nombre);

            if ($stmtx->execute()) {
                $result = $stmtx->get_result();
                if ($result->num_rows > 0) {
                    $response['success'] = true;
                    $response['dato'] = false;
                    $response['message'] = "Proveedor ya existe";        
                } else {
                    // Insertar los datos principales de la factura
                    $stmt = $connection->prepare("insert into uni_proveedor(nombre,contacto,telefono,correo,rfc) values(?,?,?,?,?)");
                    $stmt->bind_param("sssss", $nombre,$contacto,$telefono,$correo,$rfc);

                    // Cierra la declaración


                    $stmt->execute();
                    $stmt->close();
                    // Confirmar la transacción
                    $connection->commit();
                    $response['success'] = true;
                    $response['dato'] = true;
                    $response['message'] = "Datos guardados";
                    //$response['message'] = $response['message'] = "UPDATE uni_user SET Nombre = '".$usuario."', pass = '".$pass."', usuario = '".$nombre."', correo = '".$correo."', tipo = '".$tipo."', ubicacion = '".$ubicacion."', estado = '".$estatus."' WHERE idUser = '".$id."'";

                    //$response['message'] = 'Factura guardada exitosamente.';
                
                
                }
            } else {
                echo "Error en la consulta: " . $stmt->error;
            }

            
        } catch (Exception $e) {
            // Revertir la transacción en caso de error
            $connection->rollback();
            throw $e;
        } finally {
            $connection->close();
        }


  

    

// Devolver la respuesta como JSON
http_response_code($response['success'] ? 200 : 400);
echo json_encode($response);
?>