<?php
include '../conexion.php';
mysqli_set_charset($connection, "utf8");

$response = array();

// Función para enviar la respuesta como JSON
function sendResponse($success, $message, $data = null) {
    http_response_code($success ? 200 : 400);
    echo json_encode([
        'success' => $success,
        'message' => $message,
        'dato' => $data
    ]);
    exit;
}

// Verificar que la solicitud sea POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Método no permitido.');
}

// Recibir los datos enviados
$tipo = isset($_POST['tipo']) ? trim($_POST['tipo']) : null;

if ($tipo === '1') { // Alta de empleado
    $nombre = isset($_POST['nombre']) ? preg_replace('/\s{2,}/', ' ', trim($_POST['nombre'])) : null;
    $num = isset($_POST['num']) ? trim($_POST['num']) : null;
    $ubicacion = isset($_POST['ubicacion']) ? trim($_POST['ubicacion']) : null;
    $supervisor = isset($_POST['supervisor']) ? trim($_POST['supervisor']) : null;
    $lugar = isset($_POST['lugar']) ? trim($_POST['lugar']) : null;
    $completa = $ubicacion . " |" . $supervisor . " |" . $lugar;

    if (empty($nombre) || empty($num)) {
        sendResponse(false, 'Datos incompletos para el registro.');
    }

    $connection->begin_transaction();

    try {
        $stmtx = $connection->prepare("SELECT * FROM uni_empleados WHERE nombre = ?");
        $stmtx->bind_param("s", $nombre);
        $stmtx->execute();
        $result = $stmtx->get_result();

        if ($result->num_rows > 0) {
            sendResponse(true, 'Empleado ya existente.', false);
        }

        $stmt = $connection->prepare("INSERT INTO uni_empleados (nombre, num_emp, ubicacion, supervisor, lugar_trabajo, ubicacionCompleta) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssss", $nombre, $num, $ubicacion, $supervisor, $lugar, $completa);
        $stmt->execute();

        $connection->commit();
        sendResponse(true, 'Empleado registrado con éxito.', true);

    } catch (Exception $e) {
        $connection->rollback();
        sendResponse(false, 'Error al registrar empleado: ' . $e->getMessage());
    } finally {
        $stmtx->close();
        $stmt->close();
        $connection->close();
    }

} else if ($tipo === '2') { // Actualización de empleado
    $id = isset($_POST['id']) ? trim($_POST['id']) : null;
    $nombre = isset($_POST['nombre']) ? strtoupper(trim($_POST['nombre'])) : null;
    $num = isset($_POST['num']) ? trim($_POST['num']) : null;

    if (empty($id) || empty($nombre) || empty($num)) {
        sendResponse(false, 'Datos incompletos para la actualización.');
    }

    $connection->begin_transaction();

    try {
        $stmtx = $connection->prepare("SELECT * FROM uni_empleados WHERE num_emp = ?");
        $stmtx->bind_param("s", $num);
        $stmtx->execute();
        $result = $stmtx->get_result();

        if ($result->num_rows > 0) {
            sendResponse(true, 'Número de empleado ya existente.', false);
        }

        $stmt = $connection->prepare("UPDATE uni_empleados SET nombre = ?, num_emp = ? WHERE idempleado = ?");
        $stmt->bind_param("sss", $nombre, $num, $id);
        $stmt->execute();

        $connection->commit();
        sendResponse(true, 'Empleado actualizado con éxito.', true);

    } catch (Exception $e) {
        $connection->rollback();
        sendResponse(false, 'Error al actualizar empleado: ' . $e->getMessage());
    } finally {
        $stmtx->close();
        $stmt->close();
        $connection->close();
    }
} else {
    sendResponse(false, 'Tipo de operación no válida.');
}
?>
