/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.governors;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactoryContext;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.governors.MaxPagesGovernor;
import net.sf.jasperreports.governors.TimeoutGovernor;

public final class GovernorFactory
implements ScriptletFactory {
    private static final GovernorFactory INSTANCE = new GovernorFactory();

    private GovernorFactory() {
    }

    public static GovernorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public List<JRAbstractScriptlet> getScriplets(ScriptletFactoryContext context) throws JRException {
        long timeout;
        boolean timeoutEnabled;
        int maxPages;
        ArrayList<JRAbstractScriptlet> scriptlets = new ArrayList<JRAbstractScriptlet>();
        boolean maxPagesEnabled = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getBooleanProperty(context.getDataset(), "net.sf.jasperreports.governor.max.pages.enabled", true);
        if (maxPagesEnabled && (maxPages = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getIntegerProperty(context.getDataset(), "net.sf.jasperreports.governor.max.pages", 0)) > 0) {
            scriptlets.add(new MaxPagesGovernor(maxPages));
        }
        if ((timeoutEnabled = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getBooleanProperty(context.getDataset(), "net.sf.jasperreports.governor.timeout.enabled", true)) && (timeout = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getLongProperty((JRPropertiesHolder)context.getDataset(), "net.sf.jasperreports.governor.timeout", 0L)) > 0L) {
            scriptlets.add(new TimeoutGovernor(timeout));
        }
        return scriptlets;
    }

    protected JRAbstractScriptlet getScriptlet(String scriptletClassName) throws JRException {
        JRAbstractScriptlet scriptlet = null;
        try {
            Class<?> scriptletClass = JRClassLoader.loadClassForName(scriptletClassName);
            scriptlet = (JRAbstractScriptlet)scriptletClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Error loading scriptlet class : " + scriptletClassName, e);
        }
        catch (Exception e) {
            throw new JRException("Error creating scriptlet class instance : " + scriptletClassName, e);
        }
        return scriptlet;
    }
}

