<?php
include "./conexion.php";

$hoy = date('Y-m-d');
$anio = date('Y');

// Obtener la semana actual
$sqlUnidad = mysqli_query($connection, "SELECT * FROM periodos WHERE fechaInicial >= '$hoy' LIMIT 1");
$semana = null; // Inicializamos la variable para la semana
if ($data = mysqli_fetch_array($sqlUnidad)) {
    $semana = $data['semana'];
}
?>

<style>
.custom-alert {
    position: fixed;
    top: 20%;
    left: 50%;
    transform: translate(-50%, -50%);
    background-color: white;
    padding: 20px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    z-index: 1000;
    display: none;
    text-align: center;
    border-radius: 5px;
}

.custom-alert button {
    margin-top: 10px;
    padding: 5px 10px;
    cursor: pointer;
}

body {
    font-family: Arial, sans-serif;
    margin: 20px;
}

.container {
    display: flex;
    align-items: center; /* Alinea verticalmente al centro */
}

label {
    margin-right: 5px; /* Espacio entre la etiqueta y el select */
    font-weight: bold;
    color: #333;
}

select {
    width: 200px; /* Asegúrate de que todos los selects tengan la misma anchura */
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 4px;
    font-size: 12px;
    margin-right: 10px; /* Espacio entre los selects */
}

input {
    width: 200px; /* Asegúrate de que todos los selects tengan la misma anchura */
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 4px;
    font-size: 12px;
    margin-right: 10px; /* Espacio entre los selects */
}

button {
    margin-left: 10px; /* Espacio entre los selects y el botón */
    padding: 10px 15px;
    background-color: #28a745;
    color: white;
    border: none;
    border-radius: 4px;
    font-size: 12px;
    cursor: pointer;
}

button:hover {
    background-color: #218838;
}


</style>
<script src="https://kit.fontawesome.com/299e6ed7e2.js" crossorigin="anonymous"></script>
<div id="customAlert" class="custom-alert">
    <p id="alertText"></p>
    <button onclick="closeAlert()">Aceptar</button>
</div>

<div id="carga" class="custom-alert">
    <p><img src="./img/loading2.gif" alt="Cargando..."></p>
</div>

<div class="container">
            <div>
                <label>Año:<br></label>
                <select style="width:80px;" id="anio" onchange="obtenerSemanas()">
                    <?php
                    $sqlAnio = mysqli_query($connection, "SELECT DISTINCT anio FROM periodos ORDER BY anio DESC");
                    while ($data = mysqli_fetch_array($sqlAnio)) {
                        $selected = ($anio == $data['anio']) ? 'selected' : '';
                        echo "<option value=\"{$data['anio']}\" $selected>{$data['anio']}</option>";
                    }
                    ?>
                </select>
            </div>
<div id="periodos"><label>Periodo:<br>
<select id="periodo"><option>--Selecciona--</option></select></label></div>
            <div id="ubicacionx">
                <label>Ubicación:<br>
                <select id="ubicacion"><option>--Selecciona--</option></select></label>
            </div>
        
            <div id="supervisorx">
                <label>Supervisor:<br>
                <select id="supervisor"><option>--Selecciona--</option></select></label>
            </div>
        
            <div id="lugarx">
                <label>Lugar de Trabajo:<br>
                <select id="lugar"><option>--Selecciona--</option></select></label>
            </div>
            <div id="lugarzx">
                
            </div>
        
            <label><br><button onclick="buscar()">Buscar</button></label>
            <label><br><button style='background:red;' onclick="descargarFaltas()">Descargar Faltas</button></label>
                </div>
<div id="checadas"></div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
function obtenerPeriodo() {
    const semana = $('#periodo').val();

    $.ajax({
        type: "POST",
        url: "reporte.php",
        data: { semana: semana },
        success: function(msg) {
            const response = JSON.parse(msg);
            $('#checadas').html(response.respuesta);
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            $('#checadas').html('<span style="color:red;">Error en la solicitud AJAX.</span>');
        }
    });
}

function obtenerSemanas() {
    const anio = $('#anio').val();
    const semana = <?php echo $semana; ?>;

    $.ajax({
        type: "POST",
        url: "obtenerPeriodo.php",
        data: { anio: anio, semana: semana },
        success: function(msg) {
            const response = JSON.parse(msg);
            $('#periodos').html(response.respuesta);
        },
        error: function(xhr) {
            console.error(xhr.responseText);
            $('#periodos').html('<span style="color:red;">Error en la solicitud AJAX.</span>');
        }
    });
}

function buscar() {
    const anio = $('#anio').val();
    const periodo = $('#periodo').val();
    const ubicacion = $('#ubicacion').val();
    const supervisor = $('#supervisor').val();
    const lugar = $('#lugar').val();
    var lugarz= null;

    if (lugar=="x"){
        lugarz= $('#lugarz').val();
    } else{
        lugarz= 0;
    }
    
    if (periodo === '0') {
        showAlert("Selecciona un periodo para continuar");
    } else if (ubicacion === '0') {
        showAlert("Selecciona una ubicación para continuar");
    } else if (supervisor === '0') {
        showAlert("Selecciona un supervisor");
    } else {
        showCarga();

        $.ajax({
            type: "POST",
            url: "reporte3.php",
            data: { anio, periodo, ubicacion, supervisor, lugar,lugarz },
            success: function(msg) {
                closeCarga();
                var response = JSON.parse(msg);
                
                $('#checadas').html(response.respuesta);
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                $('#checadas').html('<span style="color:red;">Error en la solicitud AJAX.</span>');
            }
        });
    }
}

function descargarFaltas(){
    const anio = $('#anio').val();
    const periodo = $('#periodo').val();
    const ubicacion = $('#ubicacion').val();
    const supervisor = $('#supervisor').val();
    const lugar = $('#lugar').val();
    var lugarz= null;

    if (lugar=="x"){
        lugarz= $('#lugarz').val();
    } else{
        lugarz= 0;
    }

    if (periodo === '0') {
        showAlert("Selecciona un periodo para continuar");
    } else if (ubicacion === '0') {
        showAlert("Selecciona una ubicación para continuar");
    } else if (supervisor === '0') {
        showAlert("Selecciona un supervisor");
    } else {
        showCarga();
        $.ajax({
            type: "POST",
            url: "Faltas.php",
            data: { anio, periodo, ubicacion, supervisor, lugar,lugarz },
            success: function(msg) {
                closeCarga();
                const response = JSON.parse(msg);
                //$('#checadas').html(response.respuesta);
                var archivo=response.respuesta;
                
                var pagina='descargarE.php?file='+archivo;
                //$('#cargandoModal').modal('hide');
                descargarArchivo(pagina,archivo);
                
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                $('#checadas').html('<span style="color:red;">Error en la solicitud AJAX.</span>');
            }
        });
    }
}



function descargarArchivo(url,archivox) {
        // Crear un objeto XMLHttpRequest
        var xhr = new XMLHttpRequest();

        // Configurar la solicitud
        xhr.open('GET', url, true);
        xhr.responseType = 'blob'; // El tipo de respuesta será un blob (archivo binario)

        // Cuando la solicitud esté lista
        xhr.onload = function() {
            // Verificar si la solicitud fue exitosa (código de estado HTTP 200)
            if (xhr.status === 200) {
                // Crear un objeto URL para el blob obtenido
                var blobURL = window.URL.createObjectURL(xhr.response);

                // Crear un enlace <a> para iniciar la descarga
                var a = document.createElement('a');
                a.href = blobURL;
                a.download = archivox; // Puedes establecer el nombre del archivo aquí
                document.body.appendChild(a);
                a.click();

                // Limpiar después de la descarga
                window.URL.revokeObjectURL(blobURL);
                document.body.removeChild(a);
                
                eliminarArchivoServidor(archivox);

            }
        };

        // Enviar la solicitud
        xhr.send();
    }

    function eliminarArchivoServidor(archivo) {
    $.ajax({
        type: "POST",
        url: "eliminarArchivo.php", // Una nueva ruta en el servidor que eliminará el archivo
        data: { archivo },
        success: function(response) {
            console.log("Archivo eliminado del servidor: " + archivo);
        },
        error: function(xhr) {
            console.error("Error al intentar eliminar el archivo: " + xhr.responseText);
        }
    });
}

    window.onload = function() {
    obtenerSemanas();
    $('#periodo').focus();

    }


function showAlert(message) {
    const alertBox = document.getElementById('customAlert');
    const alertText = document.getElementById('alertText');
    alertText.textContent = message;
    alertBox.style.display = 'block';
}

function showCarga() {
    document.getElementById('carga').style.display = 'block';
}

function closeAlert() {
    document.getElementById('customAlert').style.display = 'none';
}

function closeCarga() {
    document.getElementById('carga').style.display = 'none';
}
</script>
