<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Layout</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
        }

        .container {
            display: flex;
            justify-content: space-between;
            padding: 20px;
            max-width: 80%;
            margin: 50px auto;
        }

        .left-panel {
            flex: 3;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .div-box {
            width: 90%;
            height: 300px;
            border: 1px solid black;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .right-panel {
            flex: 2;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .input-box {
            width: 100%;
            height: 40px;
            margin-bottom: 20px;
            border: 1px solid black;
            padding: 5px;
        }

        .button-group {
            display: flex;
            justify-content: space-between;
        }

        button {
            width: 45%;
            height: 40px;
            border: 1px solid black;
            background-color: white;
            cursor: pointer;
        }

        video {
            width: 100%;
            height: auto;
        }

        .hidden {
            display: none;
        }
    </style>
    <script src="https://cdn.jsdelivr.net/npm/@zxing/library@0.18.2/umd/index.min.js"></script>
</head>
<body>
    <div class="container">
        <div class="left-panel">
            <div id="interactive" class="hidden">
                <video id="video"></video>
            </div>
        </div>
        <div class="right-panel">
            <label for="input1">Nombre del Empleado:</label>
            <input type="text" id="input1" class="input-box" aria-label="Nombre del Empleado">
            <label for="input2">Mensaje:</label>
            <input type="text" id="input2" class="input-box" aria-label="Mensaje">
            <div class="button-group">
                <button id="ingresar">Ingresar</button>
                <button id="salir">Salir</button>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        let codeReader;
        let stream;
        let scannerActive = false;

        $('#ingresar').on('click', function() {
            if (!scannerActive) {
                $('#interactive').removeClass('hidden');
                startScanner();
                scannerActive = true;
            }
        });

        $('#salir').on('click', function() {
            stopScanner();
        });

        function startScanner() {
            const codeReader = new ZXing.BrowserMultiFormatReader();
            codeReader.getVideoInputDevices()
                .then((videoInputDevices) => {
                    const selectedDeviceId = videoInputDevices[1].deviceId;
                    return codeReader.decodeFromVideoDevice(selectedDeviceId, 'video', (result, err) => {
                        if (result) {
                            $('#input1').val(result.text);
                            stopScanner();
                        }
                        if (err && !(err instanceof ZXing.NotFoundException)) {
                            console.error(err);
                        }
                    });
                })
                .then((videoStream) => {
                    stream = videoStream;
                })
                .catch((err) => console.error(err));
        }

        function stopScanner() {
            if (stream && stream.getTracks) {
                stream.getTracks().forEach(track => track.stop());
            }
            $('#interactive').addClass('hidden');
            if (codeReader) {
                codeReader.reset();
            }
            scannerActive = false;
        }
    </script>
</body>
</html>
