/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class XlsxBorderInfo {
    protected static final String[] BORDER = new String[]{"top", "left", "bottom", "right"};
    protected static final int TOP_BORDER = 0;
    protected static final int LEFT_BORDER = 1;
    protected static final int BOTTOM_BORDER = 2;
    protected static final int RIGHT_BORDER = 3;
    protected String[] borderColor = new String[4];
    protected String[] borderStyle = new String[4];
    protected String[] borderPadding = new String[4];

    public XlsxBorderInfo(JRLineBox box) {
        this.setBorder(box.getTopPen(), 0);
        this.borderPadding[0] = String.valueOf(LengthUtil.twip(box.getTopPadding().intValue()));
        this.setBorder(box.getLeftPen(), 1);
        this.borderPadding[1] = String.valueOf(LengthUtil.twip(box.getLeftPadding().intValue()));
        this.setBorder(box.getBottomPen(), 2);
        this.borderPadding[2] = String.valueOf(LengthUtil.twip(box.getBottomPadding().intValue()));
        this.setBorder(box.getRightPen(), 3);
        this.borderPadding[3] = String.valueOf(LengthUtil.twip(box.getRightPadding().intValue()));
    }

    public XlsxBorderInfo(JRPen pen) {
        this.setBorder(pen, 0);
        this.setBorder(pen, 1);
        this.setBorder(pen, 2);
        this.setBorder(pen, 3);
    }

    public String getId() {
        return this.borderStyle[0] + "|" + this.borderColor[0] + "|" + this.borderStyle[1] + "|" + this.borderColor[1] + "|" + this.borderStyle[2] + "|" + this.borderColor[2] + "|" + this.borderStyle[3] + "|" + this.borderColor[3];
    }

    private void setBorder(JRPen pen, int side) {
        float width = pen.getLineWidth() == null ? 0.0f : pen.getLineWidth().floatValue();
        String style = null;
        if (width > 0.0f) {
            switch (pen.getLineStyleValue()) {
                case DOUBLE: {
                    style = "double";
                    break;
                }
                case DOTTED: {
                    style = "dotted";
                    break;
                }
                case DASHED: {
                    if (width >= 1.0f) {
                        style = "mediumDashed";
                        break;
                    }
                    style = "dashed";
                    break;
                }
                default: {
                    style = width >= 2.0f ? "thick" : (width >= 1.0f ? "medium" : (width >= 0.5f ? "thin" : "hair"));
                }
            }
        }
        this.borderStyle[side] = style;
        this.borderColor[side] = JRColorUtil.getColorHexa(pen.getLineColor());
    }
}

