/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRDefaultCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.functions.FunctionSupport;

public class JRClassGenerator {
    public static final String PROPERTY_MAX_METHOD_SIZE = "net.sf.jasperreports.compiler.max.java.method.size";
    private static final int EXPR_MAX_COUNT_PER_METHOD = 100;
    protected static final String SOURCE_EXPRESSION_ID_START = "$JR_EXPR_ID=";
    protected static final int SOURCE_EXPRESSION_ID_START_LENGTH = "$JR_EXPR_ID=".length();
    protected static final String SOURCE_EXPRESSION_ID_END = "$";
    private static Map<Byte, String> fieldPrefixMap = new HashMap<Byte, String>();
    private static Map<Byte, String> variablePrefixMap;
    private static Map<Byte, String> methodSuffixMap;
    protected final JRSourceCompileTask sourceTask;
    private final int maxMethodSize;
    protected Map<String, ? extends JRParameter> parametersMap;
    protected Map<String, JRField> fieldsMap;
    protected Map<String, JRVariable> variablesMap;
    protected JRVariable[] variables;

    protected JRClassGenerator(JRSourceCompileTask sourceTask) {
        this.sourceTask = sourceTask;
        this.parametersMap = sourceTask.getParametersMap();
        this.fieldsMap = sourceTask.getFieldsMap();
        this.variablesMap = sourceTask.getVariablesMap();
        this.variables = sourceTask.getVariables();
        JRPropertiesUtil properties = JRPropertiesUtil.getInstance(sourceTask.getJasperReportsContext());
        this.maxMethodSize = properties.getIntegerProperty(PROPERTY_MAX_METHOD_SIZE, Integer.MAX_VALUE);
    }

    public static JRCompilationSourceCode generateClass(JRSourceCompileTask sourceTask) throws JRException {
        JRClassGenerator generator = new JRClassGenerator(sourceTask);
        return generator.generateClass();
    }

    public static JRCompilationSourceCode modifySource(JRSourceCompileTask sourceTask, Set<Method> missingMethods, String sourceCode) {
        JRClassGenerator generator = new JRClassGenerator(sourceTask);
        return generator.modifySource(missingMethods, sourceCode);
    }

    protected JRCompilationSourceCode generateClass() throws JRException {
        StringBuffer sb = new StringBuffer();
        this.generateClassStart(sb);
        this.generateDeclarations(sb);
        this.generateInitMethod(sb);
        this.generateInitParamsMethod(sb);
        if (this.fieldsMap != null) {
            this.generateInitFieldsMethod(sb);
        }
        this.generateInitVarsMethod(sb);
        List<JRExpression> expressions = this.sourceTask.getExpressions();
        sb.append(this.generateMethod((byte)3, expressions));
        if (this.sourceTask.isOnlyDefaultEvaluation()) {
            ArrayList<JRExpression> empty = new ArrayList<JRExpression>();
            sb.append(this.generateMethod((byte)1, empty));
            sb.append(this.generateMethod((byte)2, empty));
        } else {
            sb.append(this.generateMethod((byte)1, expressions));
            sb.append(this.generateMethod((byte)2, expressions));
        }
        sb.append("}\n");
        String code = sb.toString();
        return this.parseSourceLines(code);
    }

    private void generateInitMethod(StringBuffer sb) {
        sb.append("\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    public void customizedInit(\n");
        sb.append("        Map pm,\n");
        sb.append("        Map fm,\n");
        sb.append("        Map vm\n");
        sb.append("        )\n");
        sb.append("    {\n");
        sb.append("        initParams(pm);\n");
        if (this.fieldsMap != null) {
            sb.append("        initFields(fm);\n");
        }
        sb.append("        initVars(vm);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
    }

    protected final void generateClassStart(StringBuffer sb) {
        sb.append("/*\n");
        sb.append(" * Generated by JasperReports - ");
        sb.append(new SimpleDateFormat().format(new Date()));
        sb.append("\n");
        sb.append(" */\n");
        sb.append("import net.sf.jasperreports.engine.*;\n");
        sb.append("import net.sf.jasperreports.engine.fill.*;\n");
        sb.append("\n");
        sb.append("import java.util.*;\n");
        sb.append("import java.math.*;\n");
        sb.append("import java.text.*;\n");
        sb.append("import java.io.*;\n");
        sb.append("import java.net.*;\n");
        sb.append("\n");
        String[] imports = this.sourceTask.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                sb.append("import ");
                sb.append(imports[i]);
                sb.append(";\n");
            }
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("/**\n");
        sb.append(" *\n");
        sb.append(" */\n");
        sb.append("public class ");
        sb.append(this.sourceTask.getUnitName());
        sb.append(" extends JREvaluator\n");
        sb.append("{\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
    }

    protected final void generateDeclarations(StringBuffer sb) {
        Iterator it;
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            Set<String> parameterNames = this.parametersMap.keySet();
            it = parameterNames.iterator();
            while (it.hasNext()) {
                sb.append("    private JRFillParameter parameter_");
                sb.append(JRStringUtil.getJavaIdentifier((String)it.next()));
                sb.append(" = null;\n");
            }
        }
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            Set<String> fieldNames = this.fieldsMap.keySet();
            it = fieldNames.iterator();
            while (it.hasNext()) {
                sb.append("    private JRFillField field_");
                sb.append(JRStringUtil.getJavaIdentifier((String)it.next()));
                sb.append(" = null;\n");
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (int i = 0; i < this.variables.length; ++i) {
                sb.append("    private JRFillVariable variable_");
                sb.append(JRStringUtil.getJavaIdentifier(this.variables[i].getName()));
                sb.append(" = null;\n");
            }
        }
    }

    protected final void generateInitParamsMethod(StringBuffer sb) throws JRException {
        Iterator<String> parIt = null;
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            parIt = this.parametersMap.keySet().iterator();
        } else {
            Set emptySet = Collections.emptySet();
            parIt = emptySet.iterator();
        }
        this.generateInitParamsMethod(sb, parIt, 0);
    }

    protected final void generateInitFieldsMethod(StringBuffer sb) throws JRException {
        Iterator<String> fieldIt = null;
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            fieldIt = this.fieldsMap.keySet().iterator();
        } else {
            Set emptySet = Collections.emptySet();
            fieldIt = emptySet.iterator();
        }
        this.generateInitFieldsMethod(sb, fieldIt, 0);
    }

    protected final void generateInitVarsMethod(StringBuffer sb) throws JRException {
        Iterator<JRVariable> varIt = null;
        if (this.variables != null && this.variables.length > 0) {
            varIt = Arrays.asList(this.variables).iterator();
        } else {
            List emptyList = Collections.emptyList();
            varIt = emptyList.iterator();
        }
        this.generateInitVarsMethod(sb, varIt, 0);
    }

    private void generateInitParamsMethod(StringBuffer sb, Iterator<String> it, int index) throws JRException {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    private void initParams");
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(Map pm)\n");
        sb.append("    {\n");
        for (int i = 0; i < 100 && it.hasNext(); ++i) {
            String parameterName = it.next();
            sb.append("        parameter_");
            sb.append(JRStringUtil.getJavaIdentifier(parameterName));
            sb.append(" = (JRFillParameter)pm.get(\"");
            sb.append(JRStringUtil.escapeJavaStringLiteral(parameterName));
            sb.append("\");\n");
        }
        if (it.hasNext()) {
            sb.append("        initParams");
            sb.append(index + 1);
            sb.append("(pm);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            this.generateInitParamsMethod(sb, it, index + 1);
        }
    }

    private void generateInitFieldsMethod(StringBuffer sb, Iterator<String> it, int index) throws JRException {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    private void initFields");
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(Map fm)\n");
        sb.append("    {\n");
        for (int i = 0; i < 100 && it.hasNext(); ++i) {
            String fieldName = it.next();
            sb.append("        field_");
            sb.append(JRStringUtil.getJavaIdentifier(fieldName));
            sb.append(" = (JRFillField)fm.get(\"");
            sb.append(JRStringUtil.escapeJavaStringLiteral(fieldName));
            sb.append("\");\n");
        }
        if (it.hasNext()) {
            sb.append("        initFields");
            sb.append(index + 1);
            sb.append("(fm);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            this.generateInitFieldsMethod(sb, it, index + 1);
        }
    }

    private void generateInitVarsMethod(StringBuffer sb, Iterator<JRVariable> it, int index) throws JRException {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        sb.append("    private void initVars");
        if (index > 0) {
            sb.append(index);
        }
        sb.append("(Map vm)\n");
        sb.append("    {\n");
        for (int i = 0; i < 100 && it.hasNext(); ++i) {
            String variableName = it.next().getName();
            sb.append("        variable_");
            sb.append(JRStringUtil.getJavaIdentifier(variableName));
            sb.append(" = (JRFillVariable)vm.get(\"");
            sb.append(JRStringUtil.escapeJavaStringLiteral(variableName));
            sb.append("\");\n");
        }
        if (it.hasNext()) {
            sb.append("        initVars");
            sb.append(index + 1);
            sb.append("(vm);\n");
        }
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
        if (it.hasNext()) {
            this.generateInitVarsMethod(sb, it, index + 1);
        }
    }

    protected final String generateMethod(byte evaluationType, List<JRExpression> expressionsList) throws JRException {
        StringBuffer sb = new StringBuffer();
        if (expressionsList.size() > 0) {
            sb.append(this.generateMethod(expressionsList.listIterator(), evaluationType));
        } else {
            sb.append("    /**\n");
            sb.append("     *\n");
            sb.append("     */\n");
            sb.append("    public Object evaluate");
            sb.append(methodSuffixMap.get(new Byte(evaluationType)));
            sb.append("(int id) throws Throwable\n");
            sb.append("    {\n");
            sb.append("        return null;\n");
            sb.append("    }\n");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    private String generateMethod(Iterator<JRExpression> it, byte evaluationType) throws JRException {
        int methodIndex = 0;
        StringBuffer sb = new StringBuffer();
        this.writeMethodStart(sb, evaluationType, methodIndex);
        ++methodIndex;
        StringBuffer expressionBuffer = new StringBuffer();
        int methodExpressionIndex = 0;
        int methodBufferStartPosition = sb.length();
        while (it.hasNext()) {
            JRExpression expression = it.next();
            expressionBuffer.setLength(0);
            this.writeExpression(expressionBuffer, expression, evaluationType);
            if (methodExpressionIndex >= 100 || methodExpressionIndex > 0 && sb.length() - methodBufferStartPosition > this.maxMethodSize) {
                this.writeMethodEnd(sb, evaluationType, it.hasNext() ? Integer.valueOf(methodIndex) : null);
                this.writeMethodStart(sb, evaluationType, methodIndex);
                ++methodIndex;
                methodExpressionIndex = 0;
                methodBufferStartPosition = sb.length();
            }
            sb.append(expressionBuffer);
            ++methodExpressionIndex;
        }
        this.writeMethodEnd(sb, evaluationType, null);
        return sb.toString();
    }

    protected void writeMethodStart(StringBuffer sb, byte evaluationType, int methodIndex) {
        sb.append("    /**\n");
        sb.append("     *\n");
        sb.append("     */\n");
        if (methodIndex > 0) {
            sb.append("    private Object evaluate");
            sb.append(methodSuffixMap.get(new Byte(evaluationType)));
            sb.append(methodIndex);
        } else {
            sb.append("    public Object evaluate");
            sb.append(methodSuffixMap.get(new Byte(evaluationType)));
        }
        sb.append("(int id) throws Throwable\n");
        sb.append("    {\n");
        sb.append("        Object value = null;\n");
        sb.append("\n");
        sb.append("        switch (id)\n");
        sb.append("        {\n");
    }

    protected void writeExpression(StringBuffer sb, JRExpression expression, byte evaluationType) {
        sb.append("            case ");
        sb.append(this.sourceTask.getExpressionId(expression));
        sb.append(" : \n");
        sb.append("            {\n");
        sb.append("                value = ");
        sb.append(this.generateExpression(expression, evaluationType));
        sb.append(";");
        this.appendExpressionComment(sb, expression);
        sb.append("\n");
        sb.append("                break;\n");
        sb.append("            }\n");
    }

    protected void writeMethodEnd(StringBuffer sb, byte evaluationType, Integer nextMethodIndex) {
        sb.append("           default :\n");
        sb.append("           {\n");
        if (nextMethodIndex != null) {
            sb.append("               value = evaluate");
            sb.append(methodSuffixMap.get(new Byte(evaluationType)));
            sb.append(nextMethodIndex);
            sb.append("(id);\n");
        }
        sb.append("           }\n");
        sb.append("        }\n");
        sb.append("        \n");
        sb.append("        return value;\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("\n");
    }

    private String generateExpression(JRExpression expression, byte evaluationType) {
        JRParameter jrParameter = null;
        JRField jrField = null;
        JRVariable jrVariable = null;
        StringBuffer sb = new StringBuffer();
        JRExpressionChunk[] chunks = expression.getChunks();
        JRExpressionChunk chunk = null;
        String chunkText = null;
        if (chunks != null && chunks.length > 0) {
            block7: for (int i = 0; i < chunks.length; ++i) {
                chunk = chunks[i];
                chunkText = chunk.getText();
                if (chunkText == null) {
                    chunkText = "";
                }
                switch (chunk.getType()) {
                    case 1: {
                        this.appendExpressionText(expression, sb, chunkText);
                        continue block7;
                    }
                    case 2: {
                        jrParameter = this.parametersMap.get(chunkText);
                        sb.append("((");
                        sb.append(jrParameter.getValueClassName());
                        sb.append(")parameter_");
                        sb.append(JRStringUtil.getJavaIdentifier(chunkText));
                        sb.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        jrField = this.fieldsMap.get(chunkText);
                        sb.append("((");
                        sb.append(jrField.getValueClassName());
                        sb.append(")field_");
                        sb.append(JRStringUtil.getJavaIdentifier(chunkText));
                        sb.append(".get");
                        sb.append(fieldPrefixMap.get(new Byte(evaluationType)));
                        sb.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        jrVariable = this.variablesMap.get(chunkText);
                        sb.append("((");
                        sb.append(jrVariable.getValueClassName());
                        sb.append(")variable_");
                        sb.append(JRStringUtil.getJavaIdentifier(chunkText));
                        sb.append(".get");
                        sb.append(variablePrefixMap.get(new Byte(evaluationType)));
                        sb.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        sb.append("str(\"");
                        sb.append(chunkText);
                        sb.append("\")");
                    }
                }
            }
        }
        if (sb.length() == 0) {
            sb.append("null");
        }
        return sb.toString();
    }

    protected void appendExpressionText(JRExpression expression, StringBuffer sb, String chunkText) {
        StringTokenizer tokenizer = new StringTokenizer(chunkText, "\n", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\n")) {
                this.appendExpressionComment(sb, expression);
            }
            sb.append(token);
        }
    }

    protected void appendExpressionComment(StringBuffer sb, JRExpression expression) {
        sb.append(" //");
        sb.append(SOURCE_EXPRESSION_ID_START);
        sb.append(this.sourceTask.getExpressionId(expression));
        sb.append(SOURCE_EXPRESSION_ID_END);
    }

    protected JRDefaultCompilationSourceCode parseSourceLines(String sourceCode) {
        ArrayList<JRExpression> expressions = new ArrayList<JRExpression>();
        int start = 0;
        int end = sourceCode.indexOf(10);
        while (end >= 0) {
            JRExpression expression = null;
            if (start < end) {
                String line = sourceCode.substring(start, end);
                expression = this.getLineExpression(line);
            }
            expressions.add(expression);
            start = end + 1;
            end = sourceCode.indexOf(10, start);
        }
        JRExpression[] lineExpressions = expressions.toArray(new JRExpression[expressions.size()]);
        return new JRDefaultCompilationSourceCode(sourceCode, lineExpressions);
    }

    protected JRExpression getLineExpression(String line) {
        int exprIdEnd;
        JRExpression expression = null;
        int exprIdStart = line.indexOf(SOURCE_EXPRESSION_ID_START);
        if (exprIdStart >= 0 && (exprIdEnd = line.indexOf(36, exprIdStart += SOURCE_EXPRESSION_ID_START_LENGTH)) >= 0) {
            try {
                int exprId = Integer.parseInt(line.substring(exprIdStart, exprIdEnd));
                expression = this.sourceTask.getExpression(exprId);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return expression;
    }

    protected JRCompilationSourceCode modifySource(Set<Method> missingMethods, String sourceCode) {
        int firstImportIndex = sourceCode.indexOf("\nimport ");
        int lastBracketIndex = sourceCode.lastIndexOf("}");
        StringBuffer importBuffer = new StringBuffer();
        StringBuffer methodBuffer = new StringBuffer();
        for (Method method : missingMethods) {
            Class<?> methodClass = method.getDeclaringClass();
            if (FunctionSupport.class.isAssignableFrom(methodClass)) {
                for (Method classMethod : methodClass.getMethods()) {
                    if (!classMethod.getName().equals(method.getName()) || !Modifier.isPublic(classMethod.getModifiers())) continue;
                    this.addMethod(methodBuffer, classMethod);
                }
                continue;
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            importBuffer.append("\nimport static " + methodClass.getName() + "." + method.getName() + ";");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(sourceCode.substring(0, firstImportIndex));
        buffer.append(importBuffer);
        buffer.append(sourceCode.substring(firstImportIndex, lastBracketIndex));
        buffer.append(methodBuffer);
        buffer.append(sourceCode.substring(lastBracketIndex));
        sourceCode = buffer.toString();
        return this.parseSourceLines(sourceCode);
    }

    protected void addMethod(StringBuffer methodBuffer, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        StringBuffer methodSignature = new StringBuffer();
        StringBuffer methodCall = new StringBuffer();
        for (int j = 0; j < paramTypes.length; ++j) {
            if (j > 0) {
                methodCall.append(", ");
                methodSignature.append(", ");
            }
            methodCall.append("arg" + j);
            Class<?> paramType = paramTypes[j];
            if (j == paramTypes.length - 1 && paramType.isArray() && method.isVarArgs()) {
                methodSignature.append(paramType.getComponentType().getName()).append("... ");
            } else {
                methodSignature.append(paramType.getName());
            }
            methodSignature.append(" arg" + j);
        }
        methodBuffer.append("    /**\n");
        methodBuffer.append("     *\n");
        methodBuffer.append("     */\n");
        methodBuffer.append("    public " + method.getReturnType().getName() + " " + method.getName() + "(" + methodSignature.toString() + ")" + "\n");
        methodBuffer.append("    {\n");
        methodBuffer.append("        return getFunctionSupport(" + method.getDeclaringClass().getName() + ".class)." + method.getName() + "(" + methodCall + ");\n");
        methodBuffer.append("    }\n");
        methodBuffer.append("\n");
        methodBuffer.append("\n");
    }

    static {
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap<Byte, String>();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap<Byte, String>();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }
}

